function gamma_free = Calcolo_Fattori_di_partecipazione(Phi, lambda, num_rigid_modes)
    % Calcolo_Fattori_di_partecipazione.m
    % Calcola Gamma^free_i in modo generalizzato
    %
    % Input:
    %   Phi             - matrice dei modi propri (colonne = modi)
    %   lambda          - vettore degli autovalori
    %   num_rigid_modes - numero di modi rigidi iniziali da escludere
    %
    % Output:
    %   gamma_free - vettore dei Gamma^free_i in percentuale

    % Verifica dimensioni consistenti
    if size(Phi, 2) ~= length(lambda)
        error('Dimensioni incompatibili tra Phi e lambda.');
    end

    % Estrai solo i modi elastici (escludi quelli rigidi)
    Phi_elas = Phi(:, num_rigid_modes+1:end);
    lambda_elas = lambda(num_rigid_modes+1:end);
    num_elas_modes = size(Phi_elas, 2);

    % Inizializza L_free e L_elas
    L_free = zeros(num_elas_modes, 1);
    L_elas = 0;

    % Calcolo L^free_i e somma per L^elas
    for i = 1:num_elas_modes
        phi_i = Phi_elas(:, i);
        li = trace((phi_i / lambda_elas(i)) * phi_i');
        L_free(i) = li;
        L_elas = L_elas + li;
    end

    % Calcolo Gamma^free in percentuale
    gamma_free = (L_free / L_elas) * 100;

    % Visualizza i risultati
    for i = 1:num_elas_modes
        true_mode_index = i + num_rigid_modes;
        fprintf('Gamma^free_%d = %.2f %%\n', true_mode_index, gamma_free(i));
    end
end
